<?php
require_once __DIR__ . '/../utils/Config.php'; require_once __DIR__ . '/Database.php'; require_once __DIR__ . '/UpgradeManager.php'; require_once __DIR__ . '/VisitorManager.php'; require_once __DIR__ . '/LanguageController.php'; class Game { private $db; private $gameState; private $lastCryptoUpdate; private $cryptoValue; private $upgradeManager; private $visitorManager; public function __construct() { $this->db = Database::getInstance(); $this->loadOrCreateGameState(); $this->initializeCryptoValue(); $this->upgradeManager = new UpgradeManager($this->db, $this->gameState); $this->visitorManager = new VisitorManager($this->db, $this->gameState, $this->upgradeManager); } private function loadOrCreateGameState() { $result = $this->db->query("SELECT * FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); if (!$result) { $this->db->query( "INSERT INTO game_state (credits, attention_level, current_year) VALUES (?, ?, ?)", [INITIAL_CREDITS, 0, 2000.0] ); $this->gameState = $this->db->query("SELECT * FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); } else { $this->gameState = $result; } } private function initializeCryptoValue() { $this->cryptoValue = 1.0; $this->lastCryptoUpdate = time(); $this->updateCryptoValue(); } public function updateCryptoValue() { $currentTime = time(); if ($currentTime - $this->lastCryptoUpdate >= CRYPTO_UPDATE_INTERVAL) { $fluctuation = (mt_rand(-50, 50) / 1000); $this->cryptoValue *= (1 + $fluctuation); $this->lastCryptoUpdate = $currentTime; } return $this->cryptoValue; } public function getGameState() { $this->gameState = $this->db->query("SELECT * FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); return $this->gameState; } public function saveGame() { $this->db->query( "UPDATE game_state SET
            credits = ?,
            attention_level = ?,
            hosting_level = ?,
            security_level = ?,
            internet_speed = ?,
            visitors = ?,
            current_visitors = ?,
            visitor_satisfaction = ?,
            storage_capacity = ?,
            storage_used = ?,
            dedicated_server = ?,
            current_year = ?,
            last_update = CURRENT_TIMESTAMP
            WHERE id = 1", [ $this->gameState['credits'], $this->gameState['attention_level'], $this->gameState['hosting_level'], $this->gameState['security_level'], $this->gameState['internet_speed'], $this->gameState['visitors'], $this->gameState['current_visitors'], $this->gameState['visitor_satisfaction'], $this->gameState['storage_capacity'], $this->gameState['storage_used'], $this->gameState['dedicated_server'], $this->gameState['current_year'] ] ); } public function addCredits($amount) { $this->gameState['credits'] += $amount; $this->saveGame(); } public function canAfford($cost) { return $this->gameState['credits'] >= $cost; } public function spendCredits($amount) { if (!$this->canAfford($amount)) { throw new Exception("Insufficient credits!"); } $this->gameState['credits'] -= $amount; $this->saveGame(); } public function handleNetMapEffect($effectType, $effectValue, $reason = 'NetMap Effect') { if (!$effectType || $effectValue == 0) { return false; } $this->gameState = $this->db->query("SELECT * FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); switch ($effectType) { case 'attention': $currentAttention = $this->gameState['attention_level']; $newAttention = max(0, min(100, $currentAttention + $effectValue)); $this->db->query("UPDATE game_state SET attention_level = ? WHERE id = 1", [$newAttention]); break; case 'credits': $currentCredits = $this->gameState['credits']; $newCredits = max(0, $currentCredits + $effectValue); $this->db->query("UPDATE game_state SET credits = ? WHERE id = 1", [$newCredits]); break; case 'satisfaction': $currentSatisfaction = $this->gameState['visitor_satisfaction']; $newSatisfaction = max(0, min(1.0, $currentSatisfaction + ($effectValue / 100))); $this->db->query("UPDATE game_state SET visitor_satisfaction = ? WHERE id = 1", [$newSatisfaction]); break; default: return false; } $this->gameState = $this->db->query("SELECT * FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); return true; } public function updateVisitorsAndAttention() { return $this->visitorManager->updateVisitorsAndAttention(); } public function getUpgradeManager() { return $this->upgradeManager; } public function getVisitorManager() { return $this->visitorManager; } public function calculateUploadTime($fileSize) { $internetSpeed = $this->gameState['internet_speed']; $activeUpgrades = $this->upgradeManager->getActiveUpgrades(); $uploadBoost = 1.0; foreach ($activeUpgrades as $upgrade) { $effects = $upgrade->getEffects(); if (isset($effects['upload_boost'])) { $uploadBoost += $effects['upload_boost']; } } $uploadTime = $fileSize / ($internetSpeed * 0.125 * $uploadBoost); return $uploadTime; } public function updateGameYear() { $this->gameState = $this->db->query("SELECT * FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $currentYear = isset($this->gameState['current_year']) ? $this->gameState['current_year'] : 2000; $currentMonth = isset($this->gameState['current_month']) ? $this->gameState['current_month'] : 1; $currentDay = isset($this->gameState['current_day']) ? $this->gameState['current_day'] : 1; $currentHour = isset($this->gameState['current_hour']) ? $this->gameState['current_hour'] : 0; $currentHour += 6; if ($currentHour >= 24) { $currentHour = $currentHour % 24; $currentDay += 1; if ($currentDay > 30) { $currentDay = 1; $currentMonth += 1; if ($currentMonth > 12) { $currentMonth = 1; $currentYear += 1; } } } $this->gameState['current_year'] = $currentYear; $this->gameState['current_month'] = $currentMonth; $this->gameState['current_day'] = $currentDay; $this->gameState['current_hour'] = $currentHour; $this->db->query( "UPDATE game_state SET
             current_year = ?,
             current_month = ?,
             current_day = ?,
             current_hour = ?
             WHERE id = 1", [$currentYear, $currentMonth, $currentDay, $currentHour] ); $formattedDate = sprintf( "%02d/%02d/%04d %02d:00", $currentDay, $currentMonth, $currentYear, $currentHour ); return $formattedDate; } public function generateForumTopics($year, $month, $quarter, $count) { if ($count <= 0) { return false; } $this->gameState = $this->db->query("SELECT * FROM game_state WHERE id = 1")->fetch(PDO::FETCH_ASSOC); $visitorCount = $this->gameState['visitors']; $langController = LanguageController::getInstance(); $currentLang = $langController->getLanguage(); $yearFactor = ($year - 2000) / 15; $harmfulProbability = 0.2 + ($yearFactor * 0.1) + (min(1, $visitorCount / 10000) * 0.1); $forumUsers = $this->getForumUsernames(); $normalTopics = $this->getTopicTemplates('normal'); $harmfulTopics = $this->getTopicTemplates('harmful'); $contentTypes = $this->getContentTypes(); $sqlInsertTopics = "INSERT INTO forum_topics (title, content, user_name, is_harmful, status, year, month, quarter, is_moderated, effect_value) VALUES "; $params = []; for ($i = 0; $i < $count; $i++) { $isHarmful = (mt_rand(1, 100) <= ($harmfulProbability * 100)) ? 1 : 0; $user = $forumUsers[array_rand($forumUsers)]; $contentType = $contentTypes[array_rand($contentTypes)]; $randomYear = mt_rand($year - 2, $year); if ($randomYear < 2000) $randomYear = 2000; $titleTemplate = $isHarmful ? $harmfulTopics[array_rand($harmfulTopics)] : $normalTopics[array_rand($normalTopics)]; $title = sprintf($titleTemplate, $contentType, mt_rand(50, 500)); $content = $this->generateTopicContent($isHarmful, $contentType, $title); $baseEffect = $isHarmful ? -0.03 - ($yearFactor * 0.04) : 0.02 + ($yearFactor * 0.01); if ($i > 0) { $sqlInsertTopics .= ","; } $sqlInsertTopics .= "(?, ?, ?, ?, 0, ?, ?, ?, 0, ?)"; array_push($params, $title, $content, $user, $isHarmful, $year, $month, $quarter, $baseEffect); } $this->db->query($sqlInsertTopics, $params); return true; } private function getForumUsernames() { return [ 'TorrentMaster42', 'PrivacySeeker', 'OpenSourceFan', 'SeedKing', 'ModderPro', 'UXDesigner', 'SecurityGuru', 'SpeedDeamon', 'GameCollector', 'MediaServer', 'DownloadWizard', 'FileSharer99', 'PirateKing', 'MediaHunter', 'DigitalNomad', 'H4ck3rM4n', 'CrackWizard', 'FastDown2000', 'FreeStuff4You', 'MovieLover99', 'TorrentNews', 'SpeedMaster', 'CrackWizard', 'MovieHacker', 'HiddenUser', 'ListMaker', 'TechExplorer', 'GamerDude', 'CodeBreaker', 'NetworkNinja' ]; } private function getTopicTemplates($type) { $langController = LanguageController::getInstance(); $translations = $langController->getTranslationSection('game.forum.topic_templates'); if (isset($translations[$type]) && is_array($translations[$type]) && !empty($translations[$type])) { return $translations[$type]; } if ($type === 'normal') { return [ 'Torrent download guide: tips on %s', 'Best alternatives for %s', 'What are your experiences with %s?', 'Fastest methods to download %s', '%s collection - anyone willing to share?', 'Recommended %s list [%d]', 'Looking for seeds for %s, can you help?', '%s installation issues and solutions', 'Which %s should I use? Recommendations?', 'Best %s lists - Discussion', '%s update released - let\'s share download links', '%s review - Experiential test results', 'Newly released %s - First impressions', 'I need help with %s', 'Which %s is the best in your opinion? - Poll', 'Solutions for %s problems - Tips' ]; } else { return [ 'CLICK! FREE DOWNLOAD LINK for %s!!!', 'USE THIS PROGRAM to download %s! %d times FASTER!', 'Automatic %s downloader - CLICK AND DOWNLOAD', 'FREE Premium %s access - Try it now!', 'WORKING %s crack - setup in %d seconds!', 'All %s serial numbers - WORKING! [%d]', 'Real %s keygen - VIRUS FREE!', 'LATEST %s keygen - CLICK DOWNLOAD!', 'DOWNLOAD THIS PROGRAM and Get Premium for %s!', 'UNLIMITED access method for %s - WORKS in %d steps!', 'DEFINITELY WORKING! Click to download %s keygen!', 'How to download %s without antivirus - FAST METHOD', 'I\'m distributing FREE %s activation code! HURRY!', 'CLICK DOWNLOAD THIS SOFTWARE to easily crack %s [%d]', 'Secret %s download method - ISP can\'t see!' ]; } } private function getContentTypes() { $langController = LanguageController::getInstance(); $translations = $langController->getTranslationSection('game.forum.content_types'); if (is_array($translations) && !empty($translations)) { return $translations; } return [ 'VPN', 'antivirus software', 'games', 'movies', 'software', 'applications', 'operating systems', 'office software', 'video editing programs', 'audio editing software', '3D modeling tools', 'design programs', 'music', 'e-books', 'TV series', 'graphics drivers', 'torrent clients' ]; } private function generateTopicContent($isHarmful, $contentType, $title) { $langController = LanguageController::getInstance(); $translations = $langController->getTranslationSection('game.forum.content_templates'); $normalContentTemplates = []; $harmfulContentTemplates = []; $normalParts = []; $harmfulParts = []; if (isset($translations['normal']) && is_array($translations['normal'])) { $normalContentTemplates = $translations['normal']; } if (isset($translations['harmful']) && is_array($translations['harmful'])) { $harmfulContentTemplates = $translations['harmful']; } if (isset($translations['normal_parts']) && is_array($translations['normal_parts'])) { $normalParts = $translations['normal_parts']; } if (isset($translations['harmful_parts']) && is_array($translations['harmful_parts'])) { $harmfulParts = $translations['harmful_parts']; } if (empty($normalContentTemplates)) { $normalContentTemplates = [ "Hello everyone,\n\nI found a new resource about %s and wanted to share. Can anyone with experience on this topic share information?\n\nThanks!", "Hi,\n\nI have a problem with %s. I'm doing %s but it's not working. Can anyone help me?\n\nThanks in advance.", "Greetings everyone,\n\nI created a resource list for %s. Hope it helps:\n\n- %s\n- %s\n- %s\n\nIf you want to add something to the list, comment.", "Forum users,\n\nI want to start a discussion about %s. Which one do you think is better? So far I've used %s and I'm quite satisfied.\n\nI'd appreciate if you share your thoughts.", "Hello,\n\nI want to share some problems and solutions I encountered while using %s:\n\n1. %s problem: %s solution\n2. %s problem: %s solution\n\nHope it helps someone." ]; } if (empty($harmfulContentTemplates)) { $harmfulContentTemplates = [ "CLICK AND EARN FREE!!!\n\nUse this secret method for %s and avoid paying! Just click this link and enter your information: [harmful link]\n\nFREE FOR EVERYONE!!!", "ATTENTION!!! THIS AMAZING OPPORTUNITY WON'T LAST!!!\n\nDownload our new %s tool and solve all your problems with %s! Look at these steps to download:\n1. Click on [harmful link]\n2. Download the file\n3. Turn off your antivirus (!)\n4. Run the installation", "SECRET HACK METHOD - FREE ACCESS for %s!\n\nDownload this program and access all premium content for free! A method nobody knows!\n\n[harmful software link]\n\nVALID ONLY THIS WEEK!!!", "GREAT OPPORTUNITY!!! UNLIMITED ACCESS to %s!\n\nThanks to our special program, you can download anything you want! To run the program:\n\n1. Download: [harmful link]\n2. Turn off Windows Defender (important!)\n3. Run as administrator\n4. Enter your information and gain UNLIMITED ACCESS!", "LATEST TECHNOLOGY: %s %d TIMES FASTER!\n\nThanks to this secret tool, you can increase your download speed incredibly! Just download and run this program: [harmful software]\n\nNO CREDIT CARD REQUIRED! TRY IT NOW!!!" ]; } if (empty($normalParts)) { $normalParts = [ "download issues", "installation errors", "performance optimization", "alternative sources", "new version features", "comparison", "best settings", "speed increase methods", "security measures", "data protection", "privacy settings", "user reviews" ]; } if (empty($harmfulParts)) { $harmfulParts = [ "free access", "free serial number", "fast download hack", "premium account hack", "crack method", "activation code cracker", "unlimited use", "license bypass", "fast download tool", "secret premium access", "special generator", "bypass method" ]; } if ($isHarmful) { $template = $harmfulContentTemplates[array_rand($harmfulContentTemplates)]; $part1 = $harmfulParts[array_rand($harmfulParts)]; $part2 = $harmfulParts[array_rand($harmfulParts)]; $part3 = $harmfulParts[array_rand($harmfulParts)]; } else { $template = $normalContentTemplates[array_rand($normalContentTemplates)]; $part1 = $normalParts[array_rand($normalParts)]; $part2 = $normalParts[array_rand($normalParts)]; $part3 = $normalParts[array_rand($normalParts)]; } return sprintf($template, $contentType, $part1, $part2, $part3, mt_rand(1, 10)); } } 